@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.SecurityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SecurityProfile - Specifies the security settings for the virtual machine instance.
 * @property enableTPM
 * @property securityType Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
 * @property uefiSettings
 */
public data class VirtualMachineInstancePropertiesSecurityProfileArgs(
    public val enableTPM: Output<Boolean>? = null,
    public val securityType: Output<Either<String, SecurityTypes>>? = null,
    public val uefiSettings: Output<VirtualMachineInstancePropertiesUefiSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesSecurityProfileArgs.builder()
            .enableTPM(enableTPM?.applyValue({ args0 -> args0 }))
            .securityType(
                securityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .uefiSettings(uefiSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesSecurityProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesSecurityProfileArgsBuilder internal constructor() {
    private var enableTPM: Output<Boolean>? = null

    private var securityType: Output<Either<String, SecurityTypes>>? = null

    private var uefiSettings: Output<VirtualMachineInstancePropertiesUefiSettingsArgs>? = null

    /**
     * @param value
     */
    @JvmName("qcwhildgjapktmqn")
    public suspend fun enableTPM(`value`: Output<Boolean>) {
        this.enableTPM = value
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
     */
    @JvmName("siaebytvronjxkoe")
    public suspend fun securityType(`value`: Output<Either<String, SecurityTypes>>) {
        this.securityType = value
    }

    /**
     * @param value
     */
    @JvmName("nbldefcfbcnyrxyp")
    public suspend
    fun uefiSettings(`value`: Output<VirtualMachineInstancePropertiesUefiSettingsArgs>) {
        this.uefiSettings = value
    }

    /**
     * @param value
     */
    @JvmName("iftegxeuwdpbyghq")
    public suspend fun enableTPM(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTPM = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
     */
    @JvmName("qdyybjnigvbxygib")
    public suspend fun securityType(`value`: Either<String, SecurityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
     */
    @JvmName("wlqgpcyjlsasomyc")
    public fun securityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
     */
    @JvmName("dwxjgawgyvstxsxt")
    public fun securityType(`value`: SecurityTypes) {
        val toBeMapped = Either.ofRight<String, SecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cngkbqjtfwduvtfy")
    public suspend fun uefiSettings(`value`: VirtualMachineInstancePropertiesUefiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uefiSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tgpliubxijngxuwo")
    public suspend
    fun uefiSettings(argument: suspend VirtualMachineInstancePropertiesUefiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesUefiSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.uefiSettings = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesSecurityProfileArgs =
        VirtualMachineInstancePropertiesSecurityProfileArgs(
            enableTPM = enableTPM,
            securityType = securityType,
            uefiSettings = uefiSettings,
        )
}
