@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkInterfacesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID - Resource Id of the network interface
 */
public data class VirtualMachinePropertiesNetworkInterfacesArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkInterfacesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkInterfacesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkInterfacesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesNetworkInterfacesArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesNetworkInterfacesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value ID - Resource Id of the network interface
     */
    @JvmName("lajtmxluwvqjegsf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value ID - Resource Id of the network interface
     */
    @JvmName("etcpwmlwjfjxsgck")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachinePropertiesNetworkInterfacesArgs =
        VirtualMachinePropertiesNetworkInterfacesArgs(
            id = id,
        )
}
