@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SecurityProfile - Specifies the security settings for the virtual machine.
 * @property enableTPM
 * @property uefiSettings
 */
public data class VirtualMachinePropertiesSecurityProfileArgs(
    public val enableTPM: Output<Boolean>? = null,
    public val uefiSettings: Output<VirtualMachinePropertiesUefiSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs.builder()
            .enableTPM(enableTPM?.applyValue({ args0 -> args0 }))
            .uefiSettings(uefiSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachinePropertiesSecurityProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesSecurityProfileArgsBuilder internal constructor() {
    private var enableTPM: Output<Boolean>? = null

    private var uefiSettings: Output<VirtualMachinePropertiesUefiSettingsArgs>? = null

    /**
     * @param value
     */
    @JvmName("fovepkgyftenftnu")
    public suspend fun enableTPM(`value`: Output<Boolean>) {
        this.enableTPM = value
    }

    /**
     * @param value
     */
    @JvmName("ubpcknckwknmbnrx")
    public suspend fun uefiSettings(`value`: Output<VirtualMachinePropertiesUefiSettingsArgs>) {
        this.uefiSettings = value
    }

    /**
     * @param value
     */
    @JvmName("xklosgukmotpiloi")
    public suspend fun enableTPM(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTPM = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtjkvhdrovuvwplk")
    public suspend fun uefiSettings(`value`: VirtualMachinePropertiesUefiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uefiSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ybrtdaajvmdevouf")
    public suspend
    fun uefiSettings(argument: suspend VirtualMachinePropertiesUefiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesUefiSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.uefiSettings = mapped
    }

    internal fun build(): VirtualMachinePropertiesSecurityProfileArgs =
        VirtualMachinePropertiesSecurityProfileArgs(
            enableTPM = enableTPM,
            uefiSettings = uefiSettings,
        )
}
