@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * StorageProfile - contains information about the disks and storage information for the virtual machine
 * @property dataDisks adds data disks to the virtual machine
 * @property imageReference Which Image to use for the virtual machine
 * @property osDisk VHD to attach as OS disk
 * @property vmConfigStoragePathId Id of the storage container that hosts the VM configuration file
 */
public data class VirtualMachinePropertiesStorageProfileArgs(
    public val dataDisks: Output<List<VirtualMachinePropertiesDataDisksArgs>>? = null,
    public val imageReference: Output<VirtualMachinePropertiesImageReferenceArgs>? = null,
    public val osDisk: Output<VirtualMachinePropertiesOsDiskArgs>? = null,
    public val vmConfigStoragePathId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmConfigStoragePathId(vmConfigStoragePathId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesStorageProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesStorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<VirtualMachinePropertiesDataDisksArgs>>? = null

    private var imageReference: Output<VirtualMachinePropertiesImageReferenceArgs>? = null

    private var osDisk: Output<VirtualMachinePropertiesOsDiskArgs>? = null

    private var vmConfigStoragePathId: Output<String>? = null

    /**
     * @param value adds data disks to the virtual machine
     */
    @JvmName("wovrtkvavglebflc")
    public suspend fun dataDisks(`value`: Output<List<VirtualMachinePropertiesDataDisksArgs>>) {
        this.dataDisks = value
    }

    @JvmName("yjiiaymlfrqvehtt")
    public suspend fun dataDisks(vararg values: Output<VirtualMachinePropertiesDataDisksArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values adds data disks to the virtual machine
     */
    @JvmName("efwplgnlscgfvcij")
    public suspend fun dataDisks(values: List<Output<VirtualMachinePropertiesDataDisksArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Which Image to use for the virtual machine
     */
    @JvmName("xoylekvkorstmeuf")
    public suspend fun imageReference(`value`: Output<VirtualMachinePropertiesImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value VHD to attach as OS disk
     */
    @JvmName("hqoetbjuhtduvuvt")
    public suspend fun osDisk(`value`: Output<VirtualMachinePropertiesOsDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Id of the storage container that hosts the VM configuration file
     */
    @JvmName("inguhdlmvfddpngu")
    public suspend fun vmConfigStoragePathId(`value`: Output<String>) {
        this.vmConfigStoragePathId = value
    }

    /**
     * @param value adds data disks to the virtual machine
     */
    @JvmName("dmhiwcyadqvgblle")
    public suspend fun dataDisks(`value`: List<VirtualMachinePropertiesDataDisksArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine
     */
    @JvmName("epbtxpkenxwguybk")
    public suspend
    fun dataDisks(argument: List<suspend VirtualMachinePropertiesDataDisksArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesDataDisksArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine
     */
    @JvmName("qsvjqncycsfeyxsh")
    public suspend fun dataDisks(
        vararg
        argument: suspend VirtualMachinePropertiesDataDisksArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesDataDisksArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine
     */
    @JvmName("qlslspmiwskiqswc")
    public suspend
    fun dataDisks(argument: suspend VirtualMachinePropertiesDataDisksArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePropertiesDataDisksArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values adds data disks to the virtual machine
     */
    @JvmName("miycpsiexdelwlcu")
    public suspend fun dataDisks(vararg values: VirtualMachinePropertiesDataDisksArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Which Image to use for the virtual machine
     */
    @JvmName("ramxrrmrlrliixfn")
    public suspend fun imageReference(`value`: VirtualMachinePropertiesImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Which Image to use for the virtual machine
     */
    @JvmName("drrnoubnqhysfvsp")
    public suspend
    fun imageReference(argument: suspend VirtualMachinePropertiesImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesImageReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value VHD to attach as OS disk
     */
    @JvmName("ijyrxhrrhmapjnwk")
    public suspend fun osDisk(`value`: VirtualMachinePropertiesOsDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument VHD to attach as OS disk
     */
    @JvmName("fgroedkwuxpfcpug")
    public suspend
    fun osDisk(argument: suspend VirtualMachinePropertiesOsDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesOsDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    /**
     * @param value Id of the storage container that hosts the VM configuration file
     */
    @JvmName("amuaedemkiorrkuj")
    public suspend fun vmConfigStoragePathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmConfigStoragePathId = mapped
    }

    internal fun build(): VirtualMachinePropertiesStorageProfileArgs =
        VirtualMachinePropertiesStorageProfileArgs(
            dataDisks = dataDisks,
            imageReference = imageReference,
            osDisk = osDisk,
            vmConfigStoragePathId = vmConfigStoragePathId,
        )
}
