@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Cluster node details.
 * @property coreCount Number of physical cores on the cluster node.
 * @property ehcResourceId Edge Hardware Center Resource Id
 * @property id Id of the node in the cluster.
 * @property lastLicensingTimestamp Most recent licensing timestamp.
 * @property manufacturer Manufacturer of the cluster node hardware.
 * @property memoryInGiB Total available memory on the cluster node (in GiB).
 * @property model Model name of the cluster node hardware.
 * @property name Name of the cluster node.
 * @property nodeType Type of the cluster node hardware.
 * @property osDisplayVersion Display version of the operating system running on the cluster node.
 * @property osName Operating system running on the cluster node.
 * @property osVersion Version of the operating system running on the cluster node.
 * @property serialNumber Immutable id of the cluster node.
 * @property windowsServerSubscription State of Windows Server Subscription.
 */
public data class ClusterNodeResponse(
    public val coreCount: Double,
    public val ehcResourceId: String,
    public val id: Double,
    public val lastLicensingTimestamp: String,
    public val manufacturer: String,
    public val memoryInGiB: Double,
    public val model: String,
    public val name: String,
    public val nodeType: String,
    public val osDisplayVersion: String,
    public val osName: String,
    public val osVersion: String,
    public val serialNumber: String,
    public val windowsServerSubscription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ClusterNodeResponse):
            ClusterNodeResponse = ClusterNodeResponse(
            coreCount = javaType.coreCount(),
            ehcResourceId = javaType.ehcResourceId(),
            id = javaType.id(),
            lastLicensingTimestamp = javaType.lastLicensingTimestamp(),
            manufacturer = javaType.manufacturer(),
            memoryInGiB = javaType.memoryInGiB(),
            model = javaType.model(),
            name = javaType.name(),
            nodeType = javaType.nodeType(),
            osDisplayVersion = javaType.osDisplayVersion(),
            osName = javaType.osName(),
            osVersion = javaType.osVersion(),
            serialNumber = javaType.serialNumber(),
            windowsServerSubscription = javaType.windowsServerSubscription(),
        )
    }
}
