@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties reported by cluster agent.
 * @property clusterId Unique id generated by the on-prem cluster.
 * @property clusterName Name of the on-prem cluster connected to this resource.
 * @property clusterType The node type of all the nodes of the cluster.
 * @property clusterVersion Version of the cluster software.
 * @property diagnosticLevel Level of diagnostic data emitted by the cluster.
 * @property imdsAttestation IMDS attestation status of the cluster.
 * @property lastUpdated Last time the cluster reported the data.
 * @property manufacturer The manufacturer of all the nodes of the cluster.
 * @property nodes List of nodes reported by the cluster.
 * @property supportedCapabilities Capabilities supported by the cluster.
 */
public data class ClusterReportedPropertiesResponse(
    public val clusterId: String,
    public val clusterName: String,
    public val clusterType: String,
    public val clusterVersion: String,
    public val diagnosticLevel: String? = null,
    public val imdsAttestation: String,
    public val lastUpdated: String,
    public val manufacturer: String,
    public val nodes: List<ClusterNodeResponse>,
    public val supportedCapabilities: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ClusterReportedPropertiesResponse):
            ClusterReportedPropertiesResponse = ClusterReportedPropertiesResponse(
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            clusterType = javaType.clusterType(),
            clusterVersion = javaType.clusterVersion(),
            diagnosticLevel = javaType.diagnosticLevel().map({ args0 -> args0 }).orElse(null),
            imdsAttestation = javaType.imdsAttestation(),
            lastUpdated = javaType.lastUpdated(),
            manufacturer = javaType.manufacturer(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterNodeResponse.Companion.toKotlin(args0)
                })
            }),
            supportedCapabilities = javaType.supportedCapabilities().map({ args0 -> args0 }),
        )
    }
}
