@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Cluster details.
 * @property aadApplicationObjectId Object id of cluster AAD identity.
 * @property aadClientId App id of cluster AAD identity.
 * @property aadServicePrincipalObjectId Id of cluster identity service principal.
 * @property aadTenantId Tenant id of cluster AAD identity.
 * @property billingModel Type of billing applied to the resource.
 * @property cloudId Unique, immutable resource id.
 * @property cloudManagementEndpoint Endpoint configured for management from the Azure portal.
 * @property desiredProperties Desired properties of the cluster.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastBillingTimestamp Most recent billing meter timestamp.
 * @property lastSyncTimestamp Most recent cluster sync timestamp.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property principalId The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property provisioningState Provisioning state.
 * @property registrationTimestamp First cluster sync timestamp.
 * @property reportedProperties Properties reported by cluster agent.
 * @property resourceProviderObjectId Object id of RP Service Principal
 * @property serviceEndpoint Region specific DataPath Endpoint of the cluster.
 * @property softwareAssuranceProperties Software Assurance properties of the cluster.
 * @property status Status of the cluster agent.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property tenantId The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property trialDaysRemaining Number of days remaining in the trial period.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class GetClusterResult(
    public val aadApplicationObjectId: String? = null,
    public val aadClientId: String? = null,
    public val aadServicePrincipalObjectId: String? = null,
    public val aadTenantId: String? = null,
    public val billingModel: String,
    public val cloudId: String,
    public val cloudManagementEndpoint: String? = null,
    public val desiredProperties: ClusterDesiredPropertiesResponse? = null,
    public val id: String,
    public val lastBillingTimestamp: String,
    public val lastSyncTimestamp: String,
    public val location: String,
    public val name: String,
    public val principalId: String,
    public val provisioningState: String,
    public val registrationTimestamp: String,
    public val reportedProperties: ClusterReportedPropertiesResponse,
    public val resourceProviderObjectId: String,
    public val serviceEndpoint: String,
    public val softwareAssuranceProperties: SoftwareAssurancePropertiesResponse? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val trialDaysRemaining: Double,
    public val type: String,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetClusterResult):
            GetClusterResult = GetClusterResult(
            aadApplicationObjectId = javaType.aadApplicationObjectId().map({ args0 -> args0 }).orElse(null),
            aadClientId = javaType.aadClientId().map({ args0 -> args0 }).orElse(null),
            aadServicePrincipalObjectId = javaType.aadServicePrincipalObjectId().map({ args0 ->
                args0
            }).orElse(null),
            aadTenantId = javaType.aadTenantId().map({ args0 -> args0 }).orElse(null),
            billingModel = javaType.billingModel(),
            cloudId = javaType.cloudId(),
            cloudManagementEndpoint = javaType.cloudManagementEndpoint().map({ args0 -> args0 }).orElse(null),
            desiredProperties = javaType.desiredProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterDesiredPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastBillingTimestamp = javaType.lastBillingTimestamp(),
            lastSyncTimestamp = javaType.lastSyncTimestamp(),
            location = javaType.location(),
            name = javaType.name(),
            principalId = javaType.principalId(),
            provisioningState = javaType.provisioningState(),
            registrationTimestamp = javaType.registrationTimestamp(),
            reportedProperties = javaType.reportedProperties().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterReportedPropertiesResponse.Companion.toKotlin(args0)
            }),
            resourceProviderObjectId = javaType.resourceProviderObjectId(),
            serviceEndpoint = javaType.serviceEndpoint(),
            softwareAssuranceProperties = javaType.softwareAssuranceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.SoftwareAssurancePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            trialDaysRemaining = javaType.trialDaysRemaining(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
