@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The network interface resource definition.
 * @property dnsSettings DNS Settings for the interface
 * @property extendedLocation The extendedLocation of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ipConfigurations IPConfigurations - A list of IPConfigurations of the network interface.
 * @property location The geo-location where the resource lives
 * @property macAddress MacAddress - The MAC address of the network interface.
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the network interface.
 * @property status The observed state of network interfaces
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkInterfaceResult(
    public val dnsSettings: InterfaceDNSSettingsResponse? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val ipConfigurations: List<IPConfigurationResponse>? = null,
    public val location: String,
    public val macAddress: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val status: NetworkInterfaceStatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetNetworkInterfaceResult):
            GetNetworkInterfaceResult = GetNetworkInterfaceResult(
            dnsSettings = javaType.dnsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.InterfaceDNSSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            macAddress = javaType.macAddress().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.NetworkInterfaceStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
