@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Update details
 * @property additionalProperties Extensible KV pairs serialized as a string. This is currently used to report the stamp OEM family and hardware model information when an update is flagged as Invalid for the stamp based on OEM type.
 * @property availabilityType Indicates the way the update content can be downloaded.
 * @property description Description of the update.
 * @property displayName Display name of the Update
 * @property healthCheckDate Last time the package-specific checks were run.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property installedDate Date that the update was installed.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property notifyMessage Brief message with instructions for updates of AvailabilityType Notify.
 * @property packagePath Path where the update package is available.
 * @property packageSizeInMb Size of the package. This value is a combination of the size from update metadata and size of the payload that results from the live scan operation for OS update content.
 * @property packageType Customer-visible type of the update.
 * @property prerequisites If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
 * @property progressPercentage Progress percentage of ongoing operation. Currently this property is only valid when the update is in the Downloading state, where it maps to how much of the update content has been downloaded.
 * @property provisioningState Provisioning state of the Updates proxy resource.
 * @property publisher Publisher of the update package.
 * @property releaseLink Link to release notes for the update.
 * @property state State of the update as it relates to this stamp.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of the update.
 */
public data class GetUpdateResult(
    public val additionalProperties: String? = null,
    public val availabilityType: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val healthCheckDate: String? = null,
    public val id: String,
    public val installedDate: String? = null,
    public val location: String? = null,
    public val name: String,
    public val notifyMessage: String? = null,
    public val packagePath: String? = null,
    public val packageSizeInMb: Double? = null,
    public val packageType: String? = null,
    public val prerequisites: List<UpdatePrerequisiteResponse>? = null,
    public val progressPercentage: Double? = null,
    public val provisioningState: String,
    public val publisher: String? = null,
    public val releaseLink: String? = null,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetUpdateResult):
            GetUpdateResult = GetUpdateResult(
            additionalProperties = javaType.additionalProperties().map({ args0 -> args0 }).orElse(null),
            availabilityType = javaType.availabilityType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            healthCheckDate = javaType.healthCheckDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            installedDate = javaType.installedDate().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notifyMessage = javaType.notifyMessage().map({ args0 -> args0 }).orElse(null),
            packagePath = javaType.packagePath().map({ args0 -> args0 }).orElse(null),
            packageSizeInMb = javaType.packageSizeInMb().map({ args0 -> args0 }).orElse(null),
            packageType = javaType.packageType().map({ args0 -> args0 }).orElse(null),
            prerequisites = javaType.prerequisites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.UpdatePrerequisiteResponse.Companion.toKotlin(args0)
                })
            }),
            progressPercentage = javaType.progressPercentage().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            releaseLink = javaType.releaseLink().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
