@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The observed state of virtual machine instances
 * @property errorCode VirtualMachine provisioning error code
 * @property errorMessage Descriptive error message
 * @property powerState The power state of the virtual machine instance
 * @property provisioningStatus
 */
public data class VirtualMachineInstanceStatusResponse(
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val powerState: String? = null,
    public val provisioningStatus: VirtualMachineInstanceStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstanceStatusResponse):
            VirtualMachineInstanceStatusResponse = VirtualMachineInstanceStatusResponse(
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            powerState = javaType.powerState().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstanceStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
