@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
 * @property dnsServers The list of DNS servers IP addresses.
 */
public data class VirtualNetworkPropertiesResponseDhcpOptions(
    public val dnsServers: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkPropertiesResponseDhcpOptions):
            VirtualNetworkPropertiesResponseDhcpOptions = VirtualNetworkPropertiesResponseDhcpOptions(
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
        )
    }
}
