@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * RouteTable for the subnet
 * @property id Etag - Gets a unique read-only string that changes whenever the resource is updated.
 * @property name Name - READ-ONLY; Resource name.
 * @property routes Routes - Collection of routes contained within a route table.
 * @property type Type - READ-ONLY; Resource type.
 */
public data class VirtualNetworkPropertiesResponseRouteTable(
    public val id: String? = null,
    public val name: String? = null,
    public val routes: List<VirtualNetworkPropertiesResponseRoutes>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkPropertiesResponseRouteTable):
            VirtualNetworkPropertiesResponseRouteTable = VirtualNetworkPropertiesResponseRouteTable(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseRoutes.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
