@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
 */
public enum class AutoUserScope(
    public val javaValue: com.pulumi.azurenative.batch.enums.AutoUserScope,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.AutoUserScope> {
    /**
     * Specifies that the service should create a new user for the task.
     */
    Task(com.pulumi.azurenative.batch.enums.AutoUserScope.Task),

    /**
     * Specifies that the task runs as the common auto user account which is created on every node in a pool.
     */
    Pool(com.pulumi.azurenative.batch.enums.AutoUserScope.Pool),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.AutoUserScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.AutoUserScope): AutoUserScope =
            AutoUserScope.values().first { it.javaValue == javaType }
    }
}
