@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the key source.
 */
public enum class KeySource(
    public val javaValue: com.pulumi.azurenative.batch.enums.KeySource,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.KeySource> {
    /**
     * Batch creates and manages the encryption keys used to protect the account data.
     */
    Microsoft_Batch(com.pulumi.azurenative.batch.enums.KeySource.Microsoft_Batch),

    /**
     * The encryption keys used to protect the account data are stored in an external key vault. If this is set then the Batch Account identity must be set to `SystemAssigned` and a valid Key Identifier must also be supplied under the keyVaultProperties.
     */
    Microsoft_KeyVault(com.pulumi.azurenative.batch.enums.KeySource.Microsoft_KeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.KeySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.KeySource): KeySource =
            KeySource.values().first { it.javaValue == javaType }
    }
}
