@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.AutoScaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property evaluationInterval If omitted, the default value is 15 minutes (PT15M).
 * @property formula
 */
public data class AutoScaleSettingsArgs(
    public val evaluationInterval: Output<String>? = null,
    public val formula: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.AutoScaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.AutoScaleSettingsArgs =
        com.pulumi.azurenative.batch.inputs.AutoScaleSettingsArgs.builder()
            .evaluationInterval(evaluationInterval?.applyValue({ args0 -> args0 }))
            .formula(formula.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoScaleSettingsArgs].
 */
@PulumiTagMarker
public class AutoScaleSettingsArgsBuilder internal constructor() {
    private var evaluationInterval: Output<String>? = null

    private var formula: Output<String>? = null

    /**
     * @param value If omitted, the default value is 15 minutes (PT15M).
     */
    @JvmName("lbipcuegxmmgdyig")
    public suspend fun evaluationInterval(`value`: Output<String>) {
        this.evaluationInterval = value
    }

    /**
     * @param value
     */
    @JvmName("xrdiuanavepjruqr")
    public suspend fun formula(`value`: Output<String>) {
        this.formula = value
    }

    /**
     * @param value If omitted, the default value is 15 minutes (PT15M).
     */
    @JvmName("irvlmpgtvjotypvh")
    public suspend fun evaluationInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("kxiwpehvsopaihpp")
    public suspend fun formula(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formula = mapped
    }

    internal fun build(): AutoScaleSettingsArgs = AutoScaleSettingsArgs(
        evaluationInterval = evaluationInterval,
        formula = formula ?: throw PulumiNullFieldException("formula"),
    )
}
