@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.DiffDiskSettingsArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.DiffDiskPlacement
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property placement This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
 */
public data class DiffDiskSettingsArgs(
    public val placement: Output<DiffDiskPlacement>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.DiffDiskSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.DiffDiskSettingsArgs =
        com.pulumi.azurenative.batch.inputs.DiffDiskSettingsArgs.builder()
            .placement(placement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DiffDiskSettingsArgs].
 */
@PulumiTagMarker
public class DiffDiskSettingsArgsBuilder internal constructor() {
    private var placement: Output<DiffDiskPlacement>? = null

    /**
     * @param value This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
     */
    @JvmName("bcbjthovvrksdvrd")
    public suspend fun placement(`value`: Output<DiffDiskPlacement>) {
        this.placement = value
    }

    /**
     * @param value This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
     */
    @JvmName("usthbflanpavsbve")
    public suspend fun placement(`value`: DiffDiskPlacement?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placement = mapped
    }

    internal fun build(): DiffDiskSettingsArgs = DiffDiskSettingsArgs(
        placement = placement,
    )
}
