@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.KeySource
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
 * @property keySource Type of the key source.
 * @property keyVaultProperties Additional details when using Microsoft.KeyVault
 */
public data class EncryptionPropertiesArgs(
    public val keySource: Output<KeySource>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.batch.inputs.EncryptionPropertiesArgs.builder()
            .keySource(keySource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var keySource: Output<KeySource>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value Type of the key source.
     */
    @JvmName("sivhmsnatvyfqilp")
    public suspend fun keySource(`value`: Output<KeySource>) {
        this.keySource = value
    }

    /**
     * @param value Additional details when using Microsoft.KeyVault
     */
    @JvmName("ofjqipelvfwuhbyq")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Type of the key source.
     */
    @JvmName("carjycasonridvad")
    public suspend fun keySource(`value`: KeySource?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Additional details when using Microsoft.KeyVault
     */
    @JvmName("etjkxqrwxwuboqne")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Additional details when using Microsoft.KeyVault
     */
    @JvmName("bnpyktyqraksjbqe")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
    )
}
