@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.FixedScaleSettingsArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ComputeNodeDeallocationOption
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeDeallocationOption If omitted, the default value is Requeue.
 * @property resizeTimeout The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
 * @property targetDedicatedNodes At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
 * @property targetLowPriorityNodes At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
 */
public data class FixedScaleSettingsArgs(
    public val nodeDeallocationOption: Output<ComputeNodeDeallocationOption>? = null,
    public val resizeTimeout: Output<String>? = null,
    public val targetDedicatedNodes: Output<Int>? = null,
    public val targetLowPriorityNodes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.FixedScaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.FixedScaleSettingsArgs =
        com.pulumi.azurenative.batch.inputs.FixedScaleSettingsArgs.builder()
            .nodeDeallocationOption(
                nodeDeallocationOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resizeTimeout(resizeTimeout?.applyValue({ args0 -> args0 }))
            .targetDedicatedNodes(targetDedicatedNodes?.applyValue({ args0 -> args0 }))
            .targetLowPriorityNodes(targetLowPriorityNodes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FixedScaleSettingsArgs].
 */
@PulumiTagMarker
public class FixedScaleSettingsArgsBuilder internal constructor() {
    private var nodeDeallocationOption: Output<ComputeNodeDeallocationOption>? = null

    private var resizeTimeout: Output<String>? = null

    private var targetDedicatedNodes: Output<Int>? = null

    private var targetLowPriorityNodes: Output<Int>? = null

    /**
     * @param value If omitted, the default value is Requeue.
     */
    @JvmName("cphgelmrffpktjjx")
    public suspend fun nodeDeallocationOption(`value`: Output<ComputeNodeDeallocationOption>) {
        this.nodeDeallocationOption = value
    }

    /**
     * @param value The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     */
    @JvmName("nccmkuwylyxhducn")
    public suspend fun resizeTimeout(`value`: Output<String>) {
        this.resizeTimeout = value
    }

    /**
     * @param value At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JvmName("pmajcnucprocavtx")
    public suspend fun targetDedicatedNodes(`value`: Output<Int>) {
        this.targetDedicatedNodes = value
    }

    /**
     * @param value At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JvmName("jxqyoyxtondmuwuq")
    public suspend fun targetLowPriorityNodes(`value`: Output<Int>) {
        this.targetLowPriorityNodes = value
    }

    /**
     * @param value If omitted, the default value is Requeue.
     */
    @JvmName("llisrpsxdcppgiyq")
    public suspend fun nodeDeallocationOption(`value`: ComputeNodeDeallocationOption?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeDeallocationOption = mapped
    }

    /**
     * @param value The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     */
    @JvmName("srhviityptefgdjx")
    public suspend fun resizeTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resizeTimeout = mapped
    }

    /**
     * @param value At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JvmName("morwiqxhgefqbaqe")
    public suspend fun targetDedicatedNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDedicatedNodes = mapped
    }

    /**
     * @param value At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JvmName("paggclbpslfxbhjl")
    public suspend fun targetLowPriorityNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetLowPriorityNodes = mapped
    }

    internal fun build(): FixedScaleSettingsArgs = FixedScaleSettingsArgs(
        nodeDeallocationOption = nodeDeallocationOption,
        resizeTimeout = resizeTimeout,
        targetDedicatedNodes = targetDedicatedNodes,
        targetLowPriorityNodes = targetLowPriorityNodes,
    )
}
