@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
 * @property offer For example, UbuntuServer or WindowsServer.
 * @property publisher For example, Canonical or MicrosoftWindowsServer.
 * @property sku For example, 18.04-LTS or 2022-datacenter.
 * @property version A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
 */
public data class ImageReferenceArgs(
    public val id: Output<String>? = null,
    public val offer: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ImageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ImageReferenceArgs =
        com.pulumi.azurenative.batch.inputs.ImageReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .offer(offer?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageReferenceArgs].
 */
@PulumiTagMarker
public class ImageReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var offer: Output<String>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     */
    @JvmName("efwoyjagfurhflol")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value For example, UbuntuServer or WindowsServer.
     */
    @JvmName("uawjgewbmertotbe")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value For example, Canonical or MicrosoftWindowsServer.
     */
    @JvmName("mrjxmvqduclgctxf")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value For example, 18.04-LTS or 2022-datacenter.
     */
    @JvmName("nsauvigwctoppuxf")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
     */
    @JvmName("afcgdcebqufyttdy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     */
    @JvmName("rsmskvnbirlsxhru")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value For example, UbuntuServer or WindowsServer.
     */
    @JvmName("ooibwinmomutrqns")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value For example, Canonical or MicrosoftWindowsServer.
     */
    @JvmName("bcwrviarsrwjwmxa")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value For example, 18.04-LTS or 2022-datacenter.
     */
    @JvmName("osscfmixfybsqbar")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
     */
    @JvmName("vdhfbhvgkoyxkpay")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ImageReferenceArgs = ImageReferenceArgs(
        id = id,
        offer = offer,
        publisher = publisher,
        sku = sku,
        version = version,
    )
}
