@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.InboundNatPoolArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.InboundEndpointProtocol
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backendPort This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
 * @property frontendPortRangeEnd Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
 * @property frontendPortRangeStart Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
 * @property name The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
 * @property networkSecurityGroupRules The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
 * @property protocol
 */
public data class InboundNatPoolArgs(
    public val backendPort: Output<Int>,
    public val frontendPortRangeEnd: Output<Int>,
    public val frontendPortRangeStart: Output<Int>,
    public val name: Output<String>,
    public val networkSecurityGroupRules: Output<List<NetworkSecurityGroupRuleArgs>>? = null,
    public val protocol: Output<InboundEndpointProtocol>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.InboundNatPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.InboundNatPoolArgs =
        com.pulumi.azurenative.batch.inputs.InboundNatPoolArgs.builder()
            .backendPort(backendPort.applyValue({ args0 -> args0 }))
            .frontendPortRangeEnd(frontendPortRangeEnd.applyValue({ args0 -> args0 }))
            .frontendPortRangeStart(frontendPortRangeStart.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .networkSecurityGroupRules(
                networkSecurityGroupRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protocol(protocol.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InboundNatPoolArgs].
 */
@PulumiTagMarker
public class InboundNatPoolArgsBuilder internal constructor() {
    private var backendPort: Output<Int>? = null

    private var frontendPortRangeEnd: Output<Int>? = null

    private var frontendPortRangeStart: Output<Int>? = null

    private var name: Output<String>? = null

    private var networkSecurityGroupRules: Output<List<NetworkSecurityGroupRuleArgs>>? = null

    private var protocol: Output<InboundEndpointProtocol>? = null

    /**
     * @param value This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
     */
    @JvmName("gqjdtsguufhqvbpn")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
     */
    @JvmName("ysggdcdfxsgxgmgl")
    public suspend fun frontendPortRangeEnd(`value`: Output<Int>) {
        this.frontendPortRangeEnd = value
    }

    /**
     * @param value Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
     */
    @JvmName("djaubgvyfcbkkcle")
    public suspend fun frontendPortRangeStart(`value`: Output<Int>) {
        this.frontendPortRangeStart = value
    }

    /**
     * @param value The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
     */
    @JvmName("buxmuuaorywbslef")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("wftygbkhsdtgrkva")
    public suspend
    fun networkSecurityGroupRules(`value`: Output<List<NetworkSecurityGroupRuleArgs>>) {
        this.networkSecurityGroupRules = value
    }

    @JvmName("kexehnsyhviofodd")
    public suspend fun networkSecurityGroupRules(
        vararg
        values: Output<NetworkSecurityGroupRuleArgs>,
    ) {
        this.networkSecurityGroupRules = Output.all(values.asList())
    }

    /**
     * @param values The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("suvkeakkhoqhhjjo")
    public suspend fun networkSecurityGroupRules(values: List<Output<NetworkSecurityGroupRuleArgs>>) {
        this.networkSecurityGroupRules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ecxsfrxgblurfglm")
    public suspend fun protocol(`value`: Output<InboundEndpointProtocol>) {
        this.protocol = value
    }

    /**
     * @param value This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
     */
    @JvmName("rxytdugoqjkumwua")
    public suspend fun backendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
     */
    @JvmName("btfeaterusobtphn")
    public suspend fun frontendPortRangeEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPortRangeEnd = mapped
    }

    /**
     * @param value Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
     */
    @JvmName("tfxrmpomxubppmfe")
    public suspend fun frontendPortRangeStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPortRangeStart = mapped
    }

    /**
     * @param value The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
     */
    @JvmName("eyiximuftgshnwwq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("ssuixfarvlpiiyeq")
    public suspend fun networkSecurityGroupRules(`value`: List<NetworkSecurityGroupRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroupRules = mapped
    }

    /**
     * @param argument The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("rlqmdqsgwypsqust")
    public suspend
    fun networkSecurityGroupRules(argument: List<suspend NetworkSecurityGroupRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityGroupRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityGroupRules = mapped
    }

    /**
     * @param argument The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("vxsskibapobdioer")
    public suspend fun networkSecurityGroupRules(
        vararg
        argument: suspend NetworkSecurityGroupRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityGroupRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityGroupRules = mapped
    }

    /**
     * @param argument The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("jseqnoucixcecxod")
    public suspend
    fun networkSecurityGroupRules(argument: suspend NetworkSecurityGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkSecurityGroupRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSecurityGroupRules = mapped
    }

    /**
     * @param values The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
     */
    @JvmName("dctrwixmoxxwfwyb")
    public suspend fun networkSecurityGroupRules(vararg values: NetworkSecurityGroupRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSecurityGroupRules = mapped
    }

    /**
     * @param value
     */
    @JvmName("upbypkhqnlweaokk")
    public suspend fun protocol(`value`: InboundEndpointProtocol) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): InboundNatPoolArgs = InboundNatPoolArgs(
        backendPort = backendPort ?: throw PulumiNullFieldException("backendPort"),
        frontendPortRangeEnd = frontendPortRangeEnd ?: throw
            PulumiNullFieldException("frontendPortRangeEnd"),
        frontendPortRangeStart = frontendPortRangeStart ?: throw
            PulumiNullFieldException("frontendPortRangeStart"),
        name = name ?: throw PulumiNullFieldException("name"),
        networkSecurityGroupRules = networkSecurityGroupRules,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
