@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.MountConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property azureBlobFileSystemConfiguration This property is mutually exclusive with all other properties.
 * @property azureFileShareConfiguration This property is mutually exclusive with all other properties.
 * @property cifsMountConfiguration This property is mutually exclusive with all other properties.
 * @property nfsMountConfiguration This property is mutually exclusive with all other properties.
 */
public data class MountConfigurationArgs(
    public val azureBlobFileSystemConfiguration: Output<AzureBlobFileSystemConfigurationArgs>? = null,
    public val azureFileShareConfiguration: Output<AzureFileShareConfigurationArgs>? = null,
    public val cifsMountConfiguration: Output<CIFSMountConfigurationArgs>? = null,
    public val nfsMountConfiguration: Output<NFSMountConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.MountConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.MountConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.MountConfigurationArgs.builder()
            .azureBlobFileSystemConfiguration(
                azureBlobFileSystemConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .azureFileShareConfiguration(
                azureFileShareConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cifsMountConfiguration(
                cifsMountConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nfsMountConfiguration(
                nfsMountConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MountConfigurationArgs].
 */
@PulumiTagMarker
public class MountConfigurationArgsBuilder internal constructor() {
    private var azureBlobFileSystemConfiguration: Output<AzureBlobFileSystemConfigurationArgs>? = null

    private var azureFileShareConfiguration: Output<AzureFileShareConfigurationArgs>? = null

    private var cifsMountConfiguration: Output<CIFSMountConfigurationArgs>? = null

    private var nfsMountConfiguration: Output<NFSMountConfigurationArgs>? = null

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("mdmdnyyagyilofmt")
    public suspend
    fun azureBlobFileSystemConfiguration(`value`: Output<AzureBlobFileSystemConfigurationArgs>) {
        this.azureBlobFileSystemConfiguration = value
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("uaalmorsxnvaudiq")
    public suspend fun azureFileShareConfiguration(`value`: Output<AzureFileShareConfigurationArgs>) {
        this.azureFileShareConfiguration = value
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("nrmtwlbhpeltpgkc")
    public suspend fun cifsMountConfiguration(`value`: Output<CIFSMountConfigurationArgs>) {
        this.cifsMountConfiguration = value
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("waxvyvjqoenxncif")
    public suspend fun nfsMountConfiguration(`value`: Output<NFSMountConfigurationArgs>) {
        this.nfsMountConfiguration = value
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("nbuqprqgvqtahpxc")
    public suspend
    fun azureBlobFileSystemConfiguration(`value`: AzureBlobFileSystemConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBlobFileSystemConfiguration = mapped
    }

    /**
     * @param argument This property is mutually exclusive with all other properties.
     */
    @JvmName("nnymrgrhubtjmrti")
    public suspend
    fun azureBlobFileSystemConfiguration(argument: suspend AzureBlobFileSystemConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureBlobFileSystemConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureBlobFileSystemConfiguration = mapped
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("byhvogxanchaldoh")
    public suspend fun azureFileShareConfiguration(`value`: AzureFileShareConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareConfiguration = mapped
    }

    /**
     * @param argument This property is mutually exclusive with all other properties.
     */
    @JvmName("bgggkpjntapavyvg")
    public suspend
    fun azureFileShareConfiguration(argument: suspend AzureFileShareConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileShareConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFileShareConfiguration = mapped
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("vpqhqhnoheyesnhg")
    public suspend fun cifsMountConfiguration(`value`: CIFSMountConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cifsMountConfiguration = mapped
    }

    /**
     * @param argument This property is mutually exclusive with all other properties.
     */
    @JvmName("holnuwkpqhvdhjkh")
    public suspend
    fun cifsMountConfiguration(argument: suspend CIFSMountConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CIFSMountConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cifsMountConfiguration = mapped
    }

    /**
     * @param value This property is mutually exclusive with all other properties.
     */
    @JvmName("rklribnylsdnueud")
    public suspend fun nfsMountConfiguration(`value`: NFSMountConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsMountConfiguration = mapped
    }

    /**
     * @param argument This property is mutually exclusive with all other properties.
     */
    @JvmName("bvbtywlnvnxevoji")
    public suspend
    fun nfsMountConfiguration(argument: suspend NFSMountConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NFSMountConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nfsMountConfiguration = mapped
    }

    internal fun build(): MountConfigurationArgs = MountConfigurationArgs(
        azureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration,
        azureFileShareConfiguration = azureFileShareConfiguration,
        cifsMountConfiguration = cifsMountConfiguration,
        nfsMountConfiguration = nfsMountConfiguration,
    )
}
