@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.NFSMountConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property source
 */
public data class NFSMountConfigurationArgs(
    public val mountOptions: Output<String>? = null,
    public val relativeMountPath: Output<String>,
    public val source: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.NFSMountConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.NFSMountConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.NFSMountConfigurationArgs.builder()
            .mountOptions(mountOptions?.applyValue({ args0 -> args0 }))
            .relativeMountPath(relativeMountPath.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NFSMountConfigurationArgs].
 */
@PulumiTagMarker
public class NFSMountConfigurationArgsBuilder internal constructor() {
    private var mountOptions: Output<String>? = null

    private var relativeMountPath: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("dcnjjnhyvwcllabg")
    public suspend fun mountOptions(`value`: Output<String>) {
        this.mountOptions = value
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("ejudunaijhnoyomu")
    public suspend fun relativeMountPath(`value`: Output<String>) {
        this.relativeMountPath = value
    }

    /**
     * @param value
     */
    @JvmName("oxlexvgyhaxcofkb")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("jbdvjesnkavxbsuv")
    public suspend fun mountOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("chtydvvbxxclqdyj")
    public suspend fun relativeMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativeMountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("rljvqlfxnqqogvwj")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): NFSMountConfigurationArgs = NFSMountConfigurationArgs(
        mountOptions = mountOptions,
        relativeMountPath = relativeMountPath ?: throw PulumiNullFieldException("relativeMountPath"),
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
