@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Network profile for Batch account, which contains network rule settings for each endpoint.
 * @property accountAccess Network access profile for batchAccount endpoint (Batch account data plane API).
 * @property nodeManagementAccess Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
 */
public data class NetworkProfileArgs(
    public val accountAccess: Output<EndpointAccessProfileArgs>? = null,
    public val nodeManagementAccess: Output<EndpointAccessProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.batch.inputs.NetworkProfileArgs.builder()
            .accountAccess(accountAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeManagementAccess(
                nodeManagementAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var accountAccess: Output<EndpointAccessProfileArgs>? = null

    private var nodeManagementAccess: Output<EndpointAccessProfileArgs>? = null

    /**
     * @param value Network access profile for batchAccount endpoint (Batch account data plane API).
     */
    @JvmName("pbgvtrucsqoivxhu")
    public suspend fun accountAccess(`value`: Output<EndpointAccessProfileArgs>) {
        this.accountAccess = value
    }

    /**
     * @param value Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
     */
    @JvmName("rksvkvtweioieati")
    public suspend fun nodeManagementAccess(`value`: Output<EndpointAccessProfileArgs>) {
        this.nodeManagementAccess = value
    }

    /**
     * @param value Network access profile for batchAccount endpoint (Batch account data plane API).
     */
    @JvmName("slahmnetshpxnajv")
    public suspend fun accountAccess(`value`: EndpointAccessProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountAccess = mapped
    }

    /**
     * @param argument Network access profile for batchAccount endpoint (Batch account data plane API).
     */
    @JvmName("huorcfkddsyesgcp")
    public suspend fun accountAccess(argument: suspend EndpointAccessProfileArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointAccessProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountAccess = mapped
    }

    /**
     * @param value Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
     */
    @JvmName("minioqraliatdwrl")
    public suspend fun nodeManagementAccess(`value`: EndpointAccessProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeManagementAccess = mapped
    }

    /**
     * @param argument Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
     */
    @JvmName("lyewildwsacxkgtm")
    public suspend
    fun nodeManagementAccess(argument: suspend EndpointAccessProfileArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointAccessProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeManagementAccess = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        accountAccess = accountAccess,
        nodeManagementAccess = nodeManagementAccess,
    )
}
