@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.PoolEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property inboundNatPools The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
 */
public data class PoolEndpointConfigurationArgs(
    public val inboundNatPools: Output<List<InboundNatPoolArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.PoolEndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.PoolEndpointConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.PoolEndpointConfigurationArgs.builder()
            .inboundNatPools(
                inboundNatPools.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PoolEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class PoolEndpointConfigurationArgsBuilder internal constructor() {
    private var inboundNatPools: Output<List<InboundNatPoolArgs>>? = null

    /**
     * @param value The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("xnrtkupnambclfii")
    public suspend fun inboundNatPools(`value`: Output<List<InboundNatPoolArgs>>) {
        this.inboundNatPools = value
    }

    @JvmName("pobhqnusbkuahubk")
    public suspend fun inboundNatPools(vararg values: Output<InboundNatPoolArgs>) {
        this.inboundNatPools = Output.all(values.asList())
    }

    /**
     * @param values The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("gviiirgwhqatiwtn")
    public suspend fun inboundNatPools(values: List<Output<InboundNatPoolArgs>>) {
        this.inboundNatPools = Output.all(values)
    }

    /**
     * @param value The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("jbxaxvbkcordpjeq")
    public suspend fun inboundNatPools(`value`: List<InboundNatPoolArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    /**
     * @param argument The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("mmmquxcmibohnkib")
    public suspend fun inboundNatPools(argument: List<suspend InboundNatPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("jetcohbekkupodgh")
    public suspend fun inboundNatPools(
        vararg
        argument: suspend InboundNatPoolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("lkpvcnpjpdibfnix")
    public suspend fun inboundNatPools(argument: suspend InboundNatPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param values The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
     */
    @JvmName("ejhetgwmxdveyith")
    public suspend fun inboundNatPools(vararg values: InboundNatPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    internal fun build(): PoolEndpointConfigurationArgs = PoolEndpointConfigurationArgs(
        inboundNatPools = inboundNatPools ?: throw PulumiNullFieldException("inboundNatPools"),
    )
}
