@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.PublicIPAddressConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.IPAddressProvisioningType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The public IP Address configuration of the networking configuration of a Pool.
 * @property ipAddressIds The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
 * @property provision The default value is BatchManaged
 */
public data class PublicIPAddressConfigurationArgs(
    public val ipAddressIds: Output<List<String>>? = null,
    public val provision: Output<IPAddressProvisioningType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.PublicIPAddressConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.PublicIPAddressConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.PublicIPAddressConfigurationArgs.builder()
            .ipAddressIds(ipAddressIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .provision(provision?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PublicIPAddressConfigurationArgs].
 */
@PulumiTagMarker
public class PublicIPAddressConfigurationArgsBuilder internal constructor() {
    private var ipAddressIds: Output<List<String>>? = null

    private var provision: Output<IPAddressProvisioningType>? = null

    /**
     * @param value The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
     */
    @JvmName("snsykkqmfgfutnwr")
    public suspend fun ipAddressIds(`value`: Output<List<String>>) {
        this.ipAddressIds = value
    }

    @JvmName("yoxtfnidaqywwyit")
    public suspend fun ipAddressIds(vararg values: Output<String>) {
        this.ipAddressIds = Output.all(values.asList())
    }

    /**
     * @param values The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
     */
    @JvmName("uoilavibealdqfcc")
    public suspend fun ipAddressIds(values: List<Output<String>>) {
        this.ipAddressIds = Output.all(values)
    }

    /**
     * @param value The default value is BatchManaged
     */
    @JvmName("hsapfyqnitevlqrv")
    public suspend fun provision(`value`: Output<IPAddressProvisioningType>) {
        this.provision = value
    }

    /**
     * @param value The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
     */
    @JvmName("vsefgnvefmggyomh")
    public suspend fun ipAddressIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressIds = mapped
    }

    /**
     * @param values The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
     */
    @JvmName("bunpossaoxwxwins")
    public suspend fun ipAddressIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressIds = mapped
    }

    /**
     * @param value The default value is BatchManaged
     */
    @JvmName("edbtbjtamrvgosxy")
    public suspend fun provision(`value`: IPAddressProvisioningType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provision = mapped
    }

    internal fun build(): PublicIPAddressConfigurationArgs = PublicIPAddressConfigurationArgs(
        ipAddressIds = ipAddressIds,
        provision = provision,
    )
}
