@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ScaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 * @property autoScale This property and fixedScale are mutually exclusive and one of the properties must be specified.
 * @property fixedScale This property and autoScale are mutually exclusive and one of the properties must be specified.
 */
public data class ScaleSettingsArgs(
    public val autoScale: Output<AutoScaleSettingsArgs>? = null,
    public val fixedScale: Output<FixedScaleSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ScaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ScaleSettingsArgs =
        com.pulumi.azurenative.batch.inputs.ScaleSettingsArgs.builder()
            .autoScale(autoScale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedScale(fixedScale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScaleSettingsArgs].
 */
@PulumiTagMarker
public class ScaleSettingsArgsBuilder internal constructor() {
    private var autoScale: Output<AutoScaleSettingsArgs>? = null

    private var fixedScale: Output<FixedScaleSettingsArgs>? = null

    /**
     * @param value This property and fixedScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("reimbqfynfhquljm")
    public suspend fun autoScale(`value`: Output<AutoScaleSettingsArgs>) {
        this.autoScale = value
    }

    /**
     * @param value This property and autoScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("sqbfmrjtjmppmkdi")
    public suspend fun fixedScale(`value`: Output<FixedScaleSettingsArgs>) {
        this.fixedScale = value
    }

    /**
     * @param value This property and fixedScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("xbgkgfxkjwxmcdyn")
    public suspend fun autoScale(`value`: AutoScaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScale = mapped
    }

    /**
     * @param argument This property and fixedScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("judsmhuakcdcncwt")
    public suspend fun autoScale(argument: suspend AutoScaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoScale = mapped
    }

    /**
     * @param value This property and autoScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("ykryliwhohtuaoio")
    public suspend fun fixedScale(`value`: FixedScaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedScale = mapped
    }

    /**
     * @param argument This property and autoScale are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("qrspaegthwrttruq")
    public suspend fun fixedScale(argument: suspend FixedScaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = FixedScaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fixedScale = mapped
    }

    internal fun build(): ScaleSettingsArgs = ScaleSettingsArgs(
        autoScale = autoScale,
        fixedScale = fixedScale,
    )
}
