@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.TaskSchedulingPolicyArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ComputeNodeFillType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeFillType
 */
public data class TaskSchedulingPolicyArgs(
    public val nodeFillType: Output<ComputeNodeFillType>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.TaskSchedulingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.TaskSchedulingPolicyArgs =
        com.pulumi.azurenative.batch.inputs.TaskSchedulingPolicyArgs.builder()
            .nodeFillType(nodeFillType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TaskSchedulingPolicyArgs].
 */
@PulumiTagMarker
public class TaskSchedulingPolicyArgsBuilder internal constructor() {
    private var nodeFillType: Output<ComputeNodeFillType>? = null

    /**
     * @param value
     */
    @JvmName("mrfelgiccgtslqdh")
    public suspend fun nodeFillType(`value`: Output<ComputeNodeFillType>) {
        this.nodeFillType = value
    }

    /**
     * @param value
     */
    @JvmName("mssvjplhyrjrottp")
    public suspend fun nodeFillType(`value`: ComputeNodeFillType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeFillType = mapped
    }

    internal fun build(): TaskSchedulingPolicyArgs = TaskSchedulingPolicyArgs(
        nodeFillType = nodeFillType ?: throw PulumiNullFieldException("nodeFillType"),
    )
}
