@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property elevationLevel The default value is nonAdmin.
 * @property scope The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
 */
public data class AutoUserSpecificationResponse(
    public val elevationLevel: String? = null,
    public val scope: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AutoUserSpecificationResponse):
            AutoUserSpecificationResponse = AutoUserSpecificationResponse(
            elevationLevel = javaType.elevationLevel().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
        )
    }
}
