@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property password
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property source
 * @property userName
 */
public data class CIFSMountConfigurationResponse(
    public val mountOptions: String? = null,
    public val password: String,
    public val relativeMountPath: String,
    public val source: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.CIFSMountConfigurationResponse):
            CIFSMountConfigurationResponse = CIFSMountConfigurationResponse(
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }).orElse(null),
            password = javaType.password(),
            relativeMountPath = javaType.relativeMountPath(),
            source = javaType.source(),
            userName = javaType.userName(),
        )
    }
}
