@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Rule to filter client IP address.
 * @property action Action when client IP address is matched.
 * @property value IPv4 address, or IPv4 address range in CIDR format.
 */
public data class IPRuleResponse(
    public val action: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.IPRuleResponse):
            IPRuleResponse = IPRuleResponse(
            action = javaType.action(),
            `value` = javaType.`value`(),
        )
    }
}
