@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
 * @property offer For example, UbuntuServer or WindowsServer.
 * @property publisher For example, Canonical or MicrosoftWindowsServer.
 * @property sku For example, 18.04-LTS or 2022-datacenter.
 * @property version A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
 */
public data class ImageReferenceResponse(
    public val id: String? = null,
    public val offer: String? = null,
    public val publisher: String? = null,
    public val sku: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ImageReferenceResponse):
            ImageReferenceResponse = ImageReferenceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
