@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.inputs

import com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByDepartmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingRoleAssignmentName The ID that uniquely identifies a role assignment.
 * @property departmentName The ID that uniquely identifies a department.
 */
public data class GetBillingRoleAssignmentByDepartmentPlainArgs(
    public val billingAccountName: String,
    public val billingRoleAssignmentName: String,
    public val departmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByDepartmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByDepartmentPlainArgs =
        com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByDepartmentPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 }))
            .billingRoleAssignmentName(billingRoleAssignmentName.let({ args0 -> args0 }))
            .departmentName(departmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingRoleAssignmentByDepartmentPlainArgs].
 */
@PulumiTagMarker
public class GetBillingRoleAssignmentByDepartmentPlainArgsBuilder internal constructor() {
    private var billingAccountName: String? = null

    private var billingRoleAssignmentName: String? = null

    private var departmentName: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("wqbmyiqxadcvugbm")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("utkdxmjbvpyagvfn")
    public suspend fun billingRoleAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingRoleAssignmentName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a department.
     */
    @JvmName("wbvnywjmegtiltip")
    public suspend fun departmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.departmentName = mapped
    }

    internal fun build(): GetBillingRoleAssignmentByDepartmentPlainArgs =
        GetBillingRoleAssignmentByDepartmentPlainArgs(
            billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
            billingRoleAssignmentName = billingRoleAssignmentName ?: throw
                PulumiNullFieldException("billingRoleAssignmentName"),
            departmentName = departmentName ?: throw PulumiNullFieldException("departmentName"),
        )
}
