@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin

import com.pulumi.azurenative.blockchain.TransactionNodeArgs.builder
import com.pulumi.azurenative.blockchain.kotlin.inputs.FirewallRuleArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.FirewallRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Payload of the transaction node which is the request/response of the resource provider.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### TransactionNodes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var transactionNode = new AzureNative.Blockchain.TransactionNode("transactionNode", new()
 *     {
 *         BlockchainMemberName = "contosemember1",
 *         Location = "southeastasia",
 *         Password = "<password>",
 *         ResourceGroupName = "mygroup",
 *         TransactionNodeName = "txnode2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blockchain/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blockchain.NewTransactionNode(ctx, "transactionNode", &blockchain.TransactionNodeArgs{
 * 			BlockchainMemberName: pulumi.String("contosemember1"),
 * 			Location:             pulumi.String("southeastasia"),
 * 			Password:             pulumi.String("<password>"),
 * 			ResourceGroupName:    pulumi.String("mygroup"),
 * 			TransactionNodeName:  pulumi.String("txnode2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blockchain.TransactionNode;
 * import com.pulumi.azurenative.blockchain.TransactionNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transactionNode = new TransactionNode("transactionNode", TransactionNodeArgs.builder()
 *             .blockchainMemberName("contosemember1")
 *             .location("southeastasia")
 *             .password("<password>")
 *             .resourceGroupName("mygroup")
 *             .transactionNodeName("txnode2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blockchain:TransactionNode txnode2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}/transactionNodes/{transactionNodeName}
 * ```
 * @property blockchainMemberName Blockchain member name.
 * @property firewallRules Gets or sets the firewall rules.
 * @property location Gets or sets the transaction node location.
 * @property password Sets the transaction node dns endpoint basic auth password.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property transactionNodeName Transaction node name.
 */
public data class TransactionNodeArgs(
    public val blockchainMemberName: Output<String>? = null,
    public val firewallRules: Output<List<FirewallRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val transactionNodeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.TransactionNodeArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.TransactionNodeArgs =
        com.pulumi.azurenative.blockchain.TransactionNodeArgs.builder()
            .blockchainMemberName(blockchainMemberName?.applyValue({ args0 -> args0 }))
            .firewallRules(
                firewallRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .transactionNodeName(transactionNodeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransactionNodeArgs].
 */
@PulumiTagMarker
public class TransactionNodeArgsBuilder internal constructor() {
    private var blockchainMemberName: Output<String>? = null

    private var firewallRules: Output<List<FirewallRuleArgs>>? = null

    private var location: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var transactionNodeName: Output<String>? = null

    /**
     * @param value Blockchain member name.
     */
    @JvmName("spvxqnqcmhrshcvj")
    public suspend fun blockchainMemberName(`value`: Output<String>) {
        this.blockchainMemberName = value
    }

    /**
     * @param value Gets or sets the firewall rules.
     */
    @JvmName("imdhptieesrkawna")
    public suspend fun firewallRules(`value`: Output<List<FirewallRuleArgs>>) {
        this.firewallRules = value
    }

    @JvmName("wmohehcntprvwxwx")
    public suspend fun firewallRules(vararg values: Output<FirewallRuleArgs>) {
        this.firewallRules = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the firewall rules.
     */
    @JvmName("hnouxprnioigenrr")
    public suspend fun firewallRules(values: List<Output<FirewallRuleArgs>>) {
        this.firewallRules = Output.all(values)
    }

    /**
     * @param value Gets or sets the transaction node location.
     */
    @JvmName("dauiqadvdbjherrx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Sets the transaction node dns endpoint basic auth password.
     */
    @JvmName("gfbsxmudhvfbqsmo")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijfgsmdojriajkbr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Transaction node name.
     */
    @JvmName("ffapfkocgiabwreq")
    public suspend fun transactionNodeName(`value`: Output<String>) {
        this.transactionNodeName = value
    }

    /**
     * @param value Blockchain member name.
     */
    @JvmName("gykksaqjcdyapmvg")
    public suspend fun blockchainMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockchainMemberName = mapped
    }

    /**
     * @param value Gets or sets the firewall rules.
     */
    @JvmName("nqbxrjkpjdoprtmd")
    public suspend fun firewallRules(`value`: List<FirewallRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets the firewall rules.
     */
    @JvmName("ljyhydjjdfhxcbsf")
    public suspend fun firewallRules(argument: List<suspend FirewallRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets the firewall rules.
     */
    @JvmName("rqadcoaphuquwsec")
    public suspend fun firewallRules(vararg argument: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets the firewall rules.
     */
    @JvmName("peqnnithrsxjfppx")
    public suspend fun firewallRules(argument: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FirewallRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param values Gets or sets the firewall rules.
     */
    @JvmName("jdoeceufyladpgfp")
    public suspend fun firewallRules(vararg values: FirewallRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param value Gets or sets the transaction node location.
     */
    @JvmName("nasawkpubxcvknah")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Sets the transaction node dns endpoint basic auth password.
     */
    @JvmName("bxhtqhhkhqwyaetd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vuvatskadboapqlg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Transaction node name.
     */
    @JvmName("duusjdriasrajcjc")
    public suspend fun transactionNodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transactionNodeName = mapped
    }

    internal fun build(): TransactionNodeArgs = TransactionNodeArgs(
        blockchainMemberName = blockchainMemberName,
        firewallRules = firewallRules,
        location = location,
        password = password,
        resourceGroupName = resourceGroupName,
        transactionNodeName = transactionNodeName,
    )
}
