@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.BlockchainMemberNodesSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Payload of the blockchain member nodes Sku for a blockchain member.
 * @property capacity Gets or sets the nodes capacity.
 */
public data class BlockchainMemberNodesSkuArgs(
    public val capacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.BlockchainMemberNodesSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.inputs.BlockchainMemberNodesSkuArgs =
        com.pulumi.azurenative.blockchain.inputs.BlockchainMemberNodesSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlockchainMemberNodesSkuArgs].
 */
@PulumiTagMarker
public class BlockchainMemberNodesSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    /**
     * @param value Gets or sets the nodes capacity.
     */
    @JvmName("kvhyeyriwtacalwl")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Gets or sets the nodes capacity.
     */
    @JvmName("hloxvtipqiseechs")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    internal fun build(): BlockchainMemberNodesSkuArgs = BlockchainMemberNodesSkuArgs(
        capacity = capacity,
    )
}
