@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Ip range for firewall rules
 * @property endIpAddress Gets or sets the end IP address of the firewall rule range.
 * @property ruleName Gets or sets the name of the firewall rules.
 * @property startIpAddress Gets or sets the start IP address of the firewall rule range.
 */
public data class FirewallRuleArgs(
    public val endIpAddress: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.inputs.FirewallRuleArgs =
        com.pulumi.azurenative.blockchain.inputs.FirewallRuleArgs.builder()
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value Gets or sets the end IP address of the firewall rule range.
     */
    @JvmName("ruibcpffwqjadlbw")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value Gets or sets the name of the firewall rules.
     */
    @JvmName("jjssmouuvpqvjvbn")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Gets or sets the start IP address of the firewall rule range.
     */
    @JvmName("qywnvgnnrbxhwego")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value Gets or sets the end IP address of the firewall rule range.
     */
    @JvmName("mocdyslmwidtvoix")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value Gets or sets the name of the firewall rules.
     */
    @JvmName("qufmoudqrqwtnbgm")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Gets or sets the start IP address of the firewall rule range.
     */
    @JvmName("flumnbgfkewohvhi")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        endIpAddress = endIpAddress,
        ruleName = ruleName,
        startIpAddress = startIpAddress,
    )
}
