@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Payload of the blockchain member nodes Sku for a blockchain member.
 * @property capacity Gets or sets the nodes capacity.
 */
public data class BlockchainMemberNodesSkuResponse(
    public val capacity: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.BlockchainMemberNodesSkuResponse):
            BlockchainMemberNodesSkuResponse = BlockchainMemberNodesSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
