@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Blueprint artifact that applies a Policy assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "force costCenter tag on all resources",
 *         Kind = "policyAssignment",
 *         Parameters =
 *         {
 *             { "tagName", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "costCenter",
 *             } },
 *             { "tagValue", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameter('costCenter')]",
 *             } },
 *         },
 *         PolicyDefinitionId = "/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			DisplayName:   pulumi.String("force costCenter tag on all resources"),
 * 			Kind:          pulumi.String("policyAssignment"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"tagName": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("costCenter"),
 * 				},
 * 				"tagValue": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameter('costCenter')]"),
 * 				},
 * 			},
 * 			PolicyDefinitionId: pulumi.String("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62"),
 * 			ResourceScope:      pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("force costCenter tag on all resources")
 *             .kind("policyAssignment")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("tagName", Map.of("value", "costCenter")),
 *                 Map.entry("tagValue", Map.of("value", "[parameter('costCenter')]"))
 *             ))
 *             .policyDefinitionId("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "force costCenter tag on all resources",
 *         Kind = "policyAssignment",
 *         Parameters =
 *         {
 *             { "tagName", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "costCenter",
 *             } },
 *             { "tagValue", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameter('costCenter')]",
 *             } },
 *         },
 *         PolicyDefinitionId = "/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			DisplayName:   pulumi.String("force costCenter tag on all resources"),
 * 			Kind:          pulumi.String("policyAssignment"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"tagName": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("costCenter"),
 * 				},
 * 				"tagValue": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameter('costCenter')]"),
 * 				},
 * 			},
 * 			PolicyDefinitionId: pulumi.String("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62"),
 * 			ResourceScope:      pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("force costCenter tag on all resources")
 *             .kind("policyAssignment")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("tagName", Map.of("value", "costCenter")),
 *                 Map.entry("tagValue", Map.of("value", "[parameter('costCenter')]"))
 *             ))
 *             .policyDefinitionId("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:PolicyAssignmentArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 * @property artifactName Name of the blueprint artifact.
 * @property blueprintName Name of the blueprint definition.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'policyAssignment'.
 * @property parameters Parameter values for the policy definition.
 * @property policyDefinitionId Azure resource ID of the policy definition.
 * @property resourceGroup Name of the resource group placeholder to which the policy will be assigned.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 */
public data class PolicyAssignmentArtifactArgs(
    public val artifactName: Output<String>? = null,
    public val blueprintName: Output<String>? = null,
    public val dependsOn: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterValueArgs>>? = null,
    public val policyDefinitionId: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceScope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs =
        com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs.builder()
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .blueprintName(blueprintName?.applyValue({ args0 -> args0 }))
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionId(policyDefinitionId?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAssignmentArtifactArgs].
 */
@PulumiTagMarker
public class PolicyAssignmentArtifactArgsBuilder internal constructor() {
    private var artifactName: Output<String>? = null

    private var blueprintName: Output<String>? = null

    private var dependsOn: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var parameters: Output<Map<String, ParameterValueArgs>>? = null

    private var policyDefinitionId: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceScope: Output<String>? = null

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("nikltjayjuevxajc")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("dwhyogaavkdpcerm")
    public suspend fun blueprintName(`value`: Output<String>) {
        this.blueprintName = value
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("urdtfvelpsyadnfu")
    public suspend fun dependsOn(`value`: Output<List<String>>) {
        this.dependsOn = value
    }

    @JvmName("psxgdogigjktqcji")
    public suspend fun dependsOn(vararg values: Output<String>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("obgylseaagchbnnq")
    public suspend fun dependsOn(values: List<Output<String>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("olrrscfdnxmyghlm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("eujtayocdgwbxrtq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'policyAssignment'.
     */
    @JvmName("gopxdymydecsmeys")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Parameter values for the policy definition.
     */
    @JvmName("jkhnbhxhbpimedgk")
    public suspend fun parameters(`value`: Output<Map<String, ParameterValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Azure resource ID of the policy definition.
     */
    @JvmName("yjloggvkmrbuhbxc")
    public suspend fun policyDefinitionId(`value`: Output<String>) {
        this.policyDefinitionId = value
    }

    /**
     * @param value Name of the resource group placeholder to which the policy will be assigned.
     */
    @JvmName("hypreybbvyjanqkh")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("atptefdeikldclrb")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("dfqnjnxdleamtboc")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("tyhbqvrqmaqoeatj")
    public suspend fun blueprintName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintName = mapped
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("clwnnugjgdqwxxjw")
    public suspend fun dependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("oibsxlpsbhxqvdqc")
    public suspend fun dependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("ltdwseiwvegckssd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("bjfddbwbutswxlei")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'policyAssignment'.
     */
    @JvmName("pxfwanrksbqamtqc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Parameter values for the policy definition.
     */
    @JvmName("prhgnaepdcmewgsx")
    public suspend fun parameters(`value`: Map<String, ParameterValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameter values for the policy definition.
     */
    @JvmName("qweelfhliucxmkro")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameter values for the policy definition.
     */
    @JvmName("jduemfrbxknaobwi")
    public fun parameters(vararg values: Pair<String, ParameterValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Azure resource ID of the policy definition.
     */
    @JvmName("xvvkgosrfrmgjbvr")
    public suspend fun policyDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionId = mapped
    }

    /**
     * @param value Name of the resource group placeholder to which the policy will be assigned.
     */
    @JvmName("iasxdhjytgntfsko")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("kbuqymwkmiuyrheq")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    internal fun build(): PolicyAssignmentArtifactArgs = PolicyAssignmentArtifactArgs(
        artifactName = artifactName,
        blueprintName = blueprintName,
        dependsOn = dependsOn,
        description = description,
        displayName = displayName,
        kind = kind,
        parameters = parameters,
        policyDefinitionId = policyDefinitionId,
        resourceGroup = resourceGroup,
        resourceScope = resourceScope,
    )
}
