@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoleAssignmentArtifact].
 */
@PulumiTagMarker
public class RoleAssignmentArtifactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssignmentArtifactArgs = RoleAssignmentArtifactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssignmentArtifactArgsBuilder.() -> Unit) {
        val builder = RoleAssignmentArtifactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleAssignmentArtifact {
        val builtJavaResource =
            com.pulumi.azurenative.blueprint.RoleAssignmentArtifact(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoleAssignmentArtifact(builtJavaResource)
    }
}

/**
 * Blueprint artifact that applies a Role assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "enforce owners of given subscription",
 *         Kind = "roleAssignment",
 *         PrincipalIds = "[parameters('owners')]",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         RoleDefinitionId = "/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:     pulumi.String("ownerAssignment"),
 * 			BlueprintName:    pulumi.String("simpleBlueprint"),
 * 			DisplayName:      pulumi.String("enforce owners of given subscription"),
 * 			Kind:             pulumi.String("roleAssignment"),
 * 			PrincipalIds:     pulumi.Any("[parameters('owners')]"),
 * 			ResourceScope:    pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			RoleDefinitionId: pulumi.String("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("enforce owners of given subscription")
 *             .kind("roleAssignment")
 *             .principalIds("[parameters('owners')]")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .roleDefinitionId("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "enforce owners of given subscription",
 *         Kind = "roleAssignment",
 *         PrincipalIds = "[parameters('owners')]",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         RoleDefinitionId = "/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:     pulumi.String("ownerAssignment"),
 * 			BlueprintName:    pulumi.String("simpleBlueprint"),
 * 			DisplayName:      pulumi.String("enforce owners of given subscription"),
 * 			Kind:             pulumi.String("roleAssignment"),
 * 			PrincipalIds:     pulumi.Any("[parameters('owners')]"),
 * 			ResourceScope:    pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			RoleDefinitionId: pulumi.String("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("enforce owners of given subscription")
 *             .kind("roleAssignment")
 *             .principalIds("[parameters('owners')]")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .roleDefinitionId("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:RoleAssignmentArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 */
public class RoleAssignmentArtifact internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.RoleAssignmentArtifact,
) : KotlinCustomResource(javaResource, RoleAssignmentArtifactMapper) {
    /**
     * Artifacts which need to be deployed before the specified artifact.
     */
    public val dependsOn: Output<List<String>>?
        get() = javaResource.dependsOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the kind of blueprint artifact.
     * Expected value is 'roleAssignment'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
     */
    public val principalIds: Output<Any>
        get() = javaResource.principalIds().applyValue({ args0 -> args0 })

    /**
     * RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
     */
    public val resourceGroup: Output<String>?
        get() = javaResource.resourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource ID of the RoleDefinition.
     */
    public val roleDefinitionId: Output<String>
        get() = javaResource.roleDefinitionId().applyValue({ args0 -> args0 })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RoleAssignmentArtifactMapper : ResourceMapper<RoleAssignmentArtifact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.RoleAssignmentArtifact::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssignmentArtifact =
        RoleAssignmentArtifact(
            javaResource as
                com.pulumi.azurenative.blueprint.RoleAssignmentArtifact,
        )
}

/**
 * @see [RoleAssignmentArtifact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssignmentArtifact].
 */
public suspend fun roleAssignmentArtifact(
    name: String,
    block: suspend RoleAssignmentArtifactResourceBuilder.() -> Unit,
): RoleAssignmentArtifact {
    val builder = RoleAssignmentArtifactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssignmentArtifact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssignmentArtifact(name: String): RoleAssignmentArtifact {
    val builder = RoleAssignmentArtifactResourceBuilder()
    builder.name(name)
    return builder.build()
}
