@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.GetTemplateArtifactPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactName Name of the blueprint artifact.
 * @property blueprintName Name of the blueprint definition.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 */
public data class GetTemplateArtifactPlainArgs(
    public val artifactName: String,
    public val blueprintName: String,
    public val resourceScope: String,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.GetTemplateArtifactPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.GetTemplateArtifactPlainArgs =
        com.pulumi.azurenative.blueprint.inputs.GetTemplateArtifactPlainArgs.builder()
            .artifactName(artifactName.let({ args0 -> args0 }))
            .blueprintName(blueprintName.let({ args0 -> args0 }))
            .resourceScope(resourceScope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplateArtifactPlainArgs].
 */
@PulumiTagMarker
public class GetTemplateArtifactPlainArgsBuilder internal constructor() {
    private var artifactName: String? = null

    private var blueprintName: String? = null

    private var resourceScope: String? = null

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("dwylvvteafljqhwf")
    public suspend fun artifactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.artifactName = mapped
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("tljmbpnucbkgrgll")
    public suspend fun blueprintName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blueprintName = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("gdoogvhsigttxwry")
    public suspend fun resourceScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceScope = mapped
    }

    internal fun build(): GetTemplateArtifactPlainArgs = GetTemplateArtifactPlainArgs(
        artifactName = artifactName ?: throw PulumiNullFieldException("artifactName"),
        blueprintName = blueprintName ?: throw PulumiNullFieldException("blueprintName"),
        resourceScope = resourceScope ?: throw PulumiNullFieldException("resourceScope"),
    )
}
