@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed identity generic object.
 * @property principalId Azure Active Directory principal ID associated with this Identity.
 * @property tenantId ID of the Azure Active Directory.
 * @property type Type of the managed identity.
 * @property userAssignedIdentities The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
 */
public data class ManagedServiceIdentityArgs(
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<Either<String, ManagedServiceIdentityType>>,
    public val userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs =
        com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedServiceIdentityArgs].
 */
@PulumiTagMarker
public class ManagedServiceIdentityArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null

    /**
     * @param value Azure Active Directory principal ID associated with this Identity.
     */
    @JvmName("nvmtamdnqwwrlqse")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value ID of the Azure Active Directory.
     */
    @JvmName("tgdrlendqlfwxdqi")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("tfmhnqxgjvunfdbu")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("vwqanqdicjqidsam")
    public suspend
    fun userAssignedIdentities(`value`: Output<Map<String, UserAssignedIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value Azure Active Directory principal ID associated with this Identity.
     */
    @JvmName("ydbyoiersuhqbwkc")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value ID of the Azure Active Directory.
     */
    @JvmName("jobppfieelulsxit")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("gncekqexgbelggnb")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("ydgobimbocftdpki")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity.
     */
    @JvmName("rfqqemsyvgglxgkq")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("nbqefkkdkgeydipg")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("pcnnfxluqctyxwyn")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserAssignedIdentityArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
     */
    @JvmName("baahefpqcmxkmcgc")
    public fun userAssignedIdentities(vararg values: Pair<String, UserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ManagedServiceIdentityArgs = ManagedServiceIdentityArgs(
        principalId = principalId,
        tenantId = tenantId,
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
