@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User-assigned managed identity.
 * @property clientId Client App Id associated with this identity.
 * @property principalId Azure Active Directory principal ID associated with this Identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String? = null,
    public val principalId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.UserAssignedIdentityResponse):
            UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
