@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.LineChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Line channel definition
 * @property channelName The channel name
 * Expected value is 'LineChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to line channel resource
 */
public data class LineChannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<LineChannelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.LineChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.LineChannelArgs =
        com.pulumi.azurenative.botservice.inputs.LineChannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LineChannelArgs].
 */
@PulumiTagMarker
public class LineChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<LineChannelPropertiesArgs>? = null

    /**
     * @param value The channel name
     * Expected value is 'LineChannel'.
     */
    @JvmName("txlhrjwlmptwcpax")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("nsbqxckhmilyltjv")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("jnsutygojvnkowcj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to line channel resource
     */
    @JvmName("apflkuhmtaxiannl")
    public suspend fun properties(`value`: Output<LineChannelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The channel name
     * Expected value is 'LineChannel'.
     */
    @JvmName("notiyqiwyxlgubud")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("eclyovwsvyyslfam")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("uatqksxuthpdkpuc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to line channel resource
     */
    @JvmName("ibuomlymyvbruory")
    public suspend fun properties(`value`: LineChannelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to line channel resource
     */
    @JvmName("jwfhxnsqoxnjiosq")
    public suspend fun properties(argument: suspend LineChannelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LineChannelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): LineChannelArgs = LineChannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
        properties = properties,
    )
}
