@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.ListQnAMakerEndpointKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authkey Subscription key which provides access to this API.
 * @property hostname the host name of the QnA Maker endpoint
 */
public data class ListQnAMakerEndpointKeyPlainArgs(
    public val authkey: String? = null,
    public val hostname: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.ListQnAMakerEndpointKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.ListQnAMakerEndpointKeyPlainArgs =
        com.pulumi.azurenative.botservice.inputs.ListQnAMakerEndpointKeyPlainArgs.builder()
            .authkey(authkey?.let({ args0 -> args0 }))
            .hostname(hostname?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListQnAMakerEndpointKeyPlainArgs].
 */
@PulumiTagMarker
public class ListQnAMakerEndpointKeyPlainArgsBuilder internal constructor() {
    private var authkey: String? = null

    private var hostname: String? = null

    /**
     * @param value Subscription key which provides access to this API.
     */
    @JvmName("ujedmdnqmngugyha")
    public suspend fun authkey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.authkey = mapped
    }

    /**
     * @param value the host name of the QnA Maker endpoint
     */
    @JvmName("qkmlfhshjdtpltjc")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostname = mapped
    }

    internal fun build(): ListQnAMakerEndpointKeyPlainArgs = ListQnAMakerEndpointKeyPlainArgs(
        authkey = authkey,
        hostname = hostname,
    )
}
