@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.SkypeChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Microsoft Teams channel.
 * @property callingWebHook Calling web hook for Skype channel
 * @property enableCalling Enable calling for Skype channel
 * @property enableGroups Enable groups for Skype channel
 * @property enableMediaCards Enable media cards for Skype channel
 * @property enableMessaging Enable messaging for Skype channel
 * @property enableScreenSharing Enable screen sharing for Skype channel
 * @property enableVideo Enable video for Skype channel
 * @property groupsMode Group mode for Skype channel
 * @property incomingCallRoute Incoming call route for Skype channel
 * @property isEnabled Whether this channel is enabled for the bot
 */
public data class SkypeChannelPropertiesArgs(
    public val callingWebHook: Output<String>? = null,
    public val enableCalling: Output<Boolean>? = null,
    public val enableGroups: Output<Boolean>? = null,
    public val enableMediaCards: Output<Boolean>? = null,
    public val enableMessaging: Output<Boolean>? = null,
    public val enableScreenSharing: Output<Boolean>? = null,
    public val enableVideo: Output<Boolean>? = null,
    public val groupsMode: Output<String>? = null,
    public val incomingCallRoute: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.SkypeChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.SkypeChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.SkypeChannelPropertiesArgs.builder()
            .callingWebHook(callingWebHook?.applyValue({ args0 -> args0 }))
            .enableCalling(enableCalling?.applyValue({ args0 -> args0 }))
            .enableGroups(enableGroups?.applyValue({ args0 -> args0 }))
            .enableMediaCards(enableMediaCards?.applyValue({ args0 -> args0 }))
            .enableMessaging(enableMessaging?.applyValue({ args0 -> args0 }))
            .enableScreenSharing(enableScreenSharing?.applyValue({ args0 -> args0 }))
            .enableVideo(enableVideo?.applyValue({ args0 -> args0 }))
            .groupsMode(groupsMode?.applyValue({ args0 -> args0 }))
            .incomingCallRoute(incomingCallRoute?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkypeChannelPropertiesArgs].
 */
@PulumiTagMarker
public class SkypeChannelPropertiesArgsBuilder internal constructor() {
    private var callingWebHook: Output<String>? = null

    private var enableCalling: Output<Boolean>? = null

    private var enableGroups: Output<Boolean>? = null

    private var enableMediaCards: Output<Boolean>? = null

    private var enableMessaging: Output<Boolean>? = null

    private var enableScreenSharing: Output<Boolean>? = null

    private var enableVideo: Output<Boolean>? = null

    private var groupsMode: Output<String>? = null

    private var incomingCallRoute: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value Calling web hook for Skype channel
     */
    @JvmName("mnxikeewtjmbfwvc")
    public suspend fun callingWebHook(`value`: Output<String>) {
        this.callingWebHook = value
    }

    /**
     * @param value Enable calling for Skype channel
     */
    @JvmName("ggcbqreyryhpwbgl")
    public suspend fun enableCalling(`value`: Output<Boolean>) {
        this.enableCalling = value
    }

    /**
     * @param value Enable groups for Skype channel
     */
    @JvmName("fngapipxxxcexyds")
    public suspend fun enableGroups(`value`: Output<Boolean>) {
        this.enableGroups = value
    }

    /**
     * @param value Enable media cards for Skype channel
     */
    @JvmName("hjqamrcyuyhdkbqg")
    public suspend fun enableMediaCards(`value`: Output<Boolean>) {
        this.enableMediaCards = value
    }

    /**
     * @param value Enable messaging for Skype channel
     */
    @JvmName("avrtukcekelwhbpn")
    public suspend fun enableMessaging(`value`: Output<Boolean>) {
        this.enableMessaging = value
    }

    /**
     * @param value Enable screen sharing for Skype channel
     */
    @JvmName("dhvodbpiwkbnanoa")
    public suspend fun enableScreenSharing(`value`: Output<Boolean>) {
        this.enableScreenSharing = value
    }

    /**
     * @param value Enable video for Skype channel
     */
    @JvmName("kmsghwfoapxuduha")
    public suspend fun enableVideo(`value`: Output<Boolean>) {
        this.enableVideo = value
    }

    /**
     * @param value Group mode for Skype channel
     */
    @JvmName("raskonpkqbknnjyd")
    public suspend fun groupsMode(`value`: Output<String>) {
        this.groupsMode = value
    }

    /**
     * @param value Incoming call route for Skype channel
     */
    @JvmName("radmpilethmotbke")
    public suspend fun incomingCallRoute(`value`: Output<String>) {
        this.incomingCallRoute = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("pdifuqkkwonfrumj")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Calling web hook for Skype channel
     */
    @JvmName("mlovjuiedtprcbvw")
    public suspend fun callingWebHook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callingWebHook = mapped
    }

    /**
     * @param value Enable calling for Skype channel
     */
    @JvmName("bghrfsubupshmewq")
    public suspend fun enableCalling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCalling = mapped
    }

    /**
     * @param value Enable groups for Skype channel
     */
    @JvmName("wnxeospyhfudksby")
    public suspend fun enableGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableGroups = mapped
    }

    /**
     * @param value Enable media cards for Skype channel
     */
    @JvmName("oxxnlqxaprqdqdsb")
    public suspend fun enableMediaCards(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMediaCards = mapped
    }

    /**
     * @param value Enable messaging for Skype channel
     */
    @JvmName("vntoeqbiwvfmevkw")
    public suspend fun enableMessaging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMessaging = mapped
    }

    /**
     * @param value Enable screen sharing for Skype channel
     */
    @JvmName("hhvwmeppjwvvajyp")
    public suspend fun enableScreenSharing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableScreenSharing = mapped
    }

    /**
     * @param value Enable video for Skype channel
     */
    @JvmName("qgtihlahahmerrnh")
    public suspend fun enableVideo(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVideo = mapped
    }

    /**
     * @param value Group mode for Skype channel
     */
    @JvmName("naqdshllvwwfqixv")
    public suspend fun groupsMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupsMode = mapped
    }

    /**
     * @param value Incoming call route for Skype channel
     */
    @JvmName("dewjlqbubjhykuvq")
    public suspend fun incomingCallRoute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incomingCallRoute = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("tuhkqhjmyrpiqkdm")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): SkypeChannelPropertiesArgs = SkypeChannelPropertiesArgs(
        callingWebHook = callingWebHook,
        enableCalling = enableCalling,
        enableGroups = enableGroups,
        enableMediaCards = enableMediaCards,
        enableMessaging = enableMessaging,
        enableScreenSharing = enableScreenSharing,
        enableVideo = enableVideo,
        groupsMode = groupsMode,
        incomingCallRoute = incomingCallRoute,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
    )
}
