@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.SlackChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Slack channel definition
 * @property channelName The channel name
 * Expected value is 'SlackChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to Slack channel resource
 */
public data class SlackChannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SlackChannelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.SlackChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.SlackChannelArgs =
        com.pulumi.azurenative.botservice.inputs.SlackChannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SlackChannelArgs].
 */
@PulumiTagMarker
public class SlackChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<SlackChannelPropertiesArgs>? = null

    /**
     * @param value The channel name
     * Expected value is 'SlackChannel'.
     */
    @JvmName("iowvrjravhgbgsif")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("exshheqvdeqmkilt")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("ccwdjttyqdhqkwsf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to Slack channel resource
     */
    @JvmName("qpjwhepvnceingrq")
    public suspend fun properties(`value`: Output<SlackChannelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The channel name
     * Expected value is 'SlackChannel'.
     */
    @JvmName("lgqdyaobmvqnchoe")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("kleknvaaqjyrgqvp")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("dgmnxqekbtmxktsu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to Slack channel resource
     */
    @JvmName("njdubajpbouynhel")
    public suspend fun properties(`value`: SlackChannelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to Slack channel resource
     */
    @JvmName("uqsbhqxklldvciup")
    public suspend fun properties(argument: suspend SlackChannelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SlackChannelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): SlackChannelArgs = SlackChannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
        properties = properties,
    )
}
