@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.WebChatSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A site for the Webchat channel
 * @property appId DirectLine application id
 * @property eTag Entity Tag
 * @property isBlockUserUploadEnabled Whether this site is enabled for block user upload.
 * @property isDetailedLoggingEnabled Whether this site is disabled detailed logging for
 * @property isEnabled Whether this site is enabled for DirectLine channel
 * @property isEndpointParametersEnabled Whether this site is EndpointParameters enabled for channel
 * @property isNoStorageEnabled Whether this no-storage site is disabled detailed logging for
 * @property isSecureSiteEnabled Whether this site is enabled for authentication with Bot Framework.
 * @property isV1Enabled Whether this site is enabled for Bot Framework V1 protocol.
 * @property isV3Enabled Whether this site is enabled for Bot Framework V3 protocol.
 * @property isWebChatSpeechEnabled Whether this site is enabled for Webchat Speech
 * @property isWebchatPreviewEnabled Whether this site is enabled for preview versions of Webchat
 * @property siteName Site name
 * @property tenantId Tenant Id
 * @property trustedOrigins List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
 */
public data class WebChatSiteArgs(
    public val appId: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val isBlockUserUploadEnabled: Output<Boolean>? = null,
    public val isDetailedLoggingEnabled: Output<Boolean>? = null,
    public val isEnabled: Output<Boolean>,
    public val isEndpointParametersEnabled: Output<Boolean>? = null,
    public val isNoStorageEnabled: Output<Boolean>? = null,
    public val isSecureSiteEnabled: Output<Boolean>? = null,
    public val isV1Enabled: Output<Boolean>? = null,
    public val isV3Enabled: Output<Boolean>? = null,
    public val isWebChatSpeechEnabled: Output<Boolean>? = null,
    public val isWebchatPreviewEnabled: Output<Boolean>,
    public val siteName: Output<String>,
    public val tenantId: Output<String>? = null,
    public val trustedOrigins: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.WebChatSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.WebChatSiteArgs =
        com.pulumi.azurenative.botservice.inputs.WebChatSiteArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .isBlockUserUploadEnabled(isBlockUserUploadEnabled?.applyValue({ args0 -> args0 }))
            .isDetailedLoggingEnabled(isDetailedLoggingEnabled?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .isEndpointParametersEnabled(isEndpointParametersEnabled?.applyValue({ args0 -> args0 }))
            .isNoStorageEnabled(isNoStorageEnabled?.applyValue({ args0 -> args0 }))
            .isSecureSiteEnabled(isSecureSiteEnabled?.applyValue({ args0 -> args0 }))
            .isV1Enabled(isV1Enabled?.applyValue({ args0 -> args0 }))
            .isV3Enabled(isV3Enabled?.applyValue({ args0 -> args0 }))
            .isWebChatSpeechEnabled(isWebChatSpeechEnabled?.applyValue({ args0 -> args0 }))
            .isWebchatPreviewEnabled(isWebchatPreviewEnabled.applyValue({ args0 -> args0 }))
            .siteName(siteName.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .trustedOrigins(trustedOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebChatSiteArgs].
 */
@PulumiTagMarker
public class WebChatSiteArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var eTag: Output<String>? = null

    private var isBlockUserUploadEnabled: Output<Boolean>? = null

    private var isDetailedLoggingEnabled: Output<Boolean>? = null

    private var isEnabled: Output<Boolean>? = null

    private var isEndpointParametersEnabled: Output<Boolean>? = null

    private var isNoStorageEnabled: Output<Boolean>? = null

    private var isSecureSiteEnabled: Output<Boolean>? = null

    private var isV1Enabled: Output<Boolean>? = null

    private var isV3Enabled: Output<Boolean>? = null

    private var isWebChatSpeechEnabled: Output<Boolean>? = null

    private var isWebchatPreviewEnabled: Output<Boolean>? = null

    private var siteName: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var trustedOrigins: Output<List<String>>? = null

    /**
     * @param value DirectLine application id
     */
    @JvmName("oskiwthflyjhukhe")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Entity Tag
     */
    @JvmName("bfbxjupfjoosvosw")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Whether this site is enabled for block user upload.
     */
    @JvmName("mwmfubromhsbcnyg")
    public suspend fun isBlockUserUploadEnabled(`value`: Output<Boolean>) {
        this.isBlockUserUploadEnabled = value
    }

    /**
     * @param value Whether this site is disabled detailed logging for
     */
    @JvmName("huhstremvqnvnrxb")
    public suspend fun isDetailedLoggingEnabled(`value`: Output<Boolean>) {
        this.isDetailedLoggingEnabled = value
    }

    /**
     * @param value Whether this site is enabled for DirectLine channel
     */
    @JvmName("wuehogrxvtfwmdaa")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Whether this site is EndpointParameters enabled for channel
     */
    @JvmName("kjvgdnhvpxiwupvj")
    public suspend fun isEndpointParametersEnabled(`value`: Output<Boolean>) {
        this.isEndpointParametersEnabled = value
    }

    /**
     * @param value Whether this no-storage site is disabled detailed logging for
     */
    @JvmName("vapnkfpylrydqmvp")
    public suspend fun isNoStorageEnabled(`value`: Output<Boolean>) {
        this.isNoStorageEnabled = value
    }

    /**
     * @param value Whether this site is enabled for authentication with Bot Framework.
     */
    @JvmName("drdmwunghtmjujug")
    public suspend fun isSecureSiteEnabled(`value`: Output<Boolean>) {
        this.isSecureSiteEnabled = value
    }

    /**
     * @param value Whether this site is enabled for Bot Framework V1 protocol.
     */
    @JvmName("cisuawoujeljtouc")
    public suspend fun isV1Enabled(`value`: Output<Boolean>) {
        this.isV1Enabled = value
    }

    /**
     * @param value Whether this site is enabled for Bot Framework V3 protocol.
     */
    @JvmName("qspctbdhuhoyhdbc")
    public suspend fun isV3Enabled(`value`: Output<Boolean>) {
        this.isV3Enabled = value
    }

    /**
     * @param value Whether this site is enabled for Webchat Speech
     */
    @JvmName("gjoteyvwktslwfxj")
    public suspend fun isWebChatSpeechEnabled(`value`: Output<Boolean>) {
        this.isWebChatSpeechEnabled = value
    }

    /**
     * @param value Whether this site is enabled for preview versions of Webchat
     */
    @JvmName("ljgfndcsfsumotry")
    public suspend fun isWebchatPreviewEnabled(`value`: Output<Boolean>) {
        this.isWebchatPreviewEnabled = value
    }

    /**
     * @param value Site name
     */
    @JvmName("hqniyfnmofrriddv")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Tenant Id
     */
    @JvmName("ivfyftpeuqqnaqnd")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
     */
    @JvmName("kqesjnrrwdnqqnrf")
    public suspend fun trustedOrigins(`value`: Output<List<String>>) {
        this.trustedOrigins = value
    }

    @JvmName("oqdgiuhegstkubte")
    public suspend fun trustedOrigins(vararg values: Output<String>) {
        this.trustedOrigins = Output.all(values.asList())
    }

    /**
     * @param values List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
     */
    @JvmName("kruexrmksxkeirat")
    public suspend fun trustedOrigins(values: List<Output<String>>) {
        this.trustedOrigins = Output.all(values)
    }

    /**
     * @param value DirectLine application id
     */
    @JvmName("cbekiblllygmrlyl")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Entity Tag
     */
    @JvmName("ycsystrdapollfty")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Whether this site is enabled for block user upload.
     */
    @JvmName("uijqrwgwkrcjvvyw")
    public suspend fun isBlockUserUploadEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isBlockUserUploadEnabled = mapped
    }

    /**
     * @param value Whether this site is disabled detailed logging for
     */
    @JvmName("xqgcoeleehjbwvbp")
    public suspend fun isDetailedLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDetailedLoggingEnabled = mapped
    }

    /**
     * @param value Whether this site is enabled for DirectLine channel
     */
    @JvmName("kejsiptolsskovlw")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Whether this site is EndpointParameters enabled for channel
     */
    @JvmName("vaqfgtoecvfuadpw")
    public suspend fun isEndpointParametersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEndpointParametersEnabled = mapped
    }

    /**
     * @param value Whether this no-storage site is disabled detailed logging for
     */
    @JvmName("uaxsrwjaulxeiacc")
    public suspend fun isNoStorageEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isNoStorageEnabled = mapped
    }

    /**
     * @param value Whether this site is enabled for authentication with Bot Framework.
     */
    @JvmName("tauxmbtnfwmlkuxm")
    public suspend fun isSecureSiteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecureSiteEnabled = mapped
    }

    /**
     * @param value Whether this site is enabled for Bot Framework V1 protocol.
     */
    @JvmName("jmgrmkmpxrdyqnci")
    public suspend fun isV1Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isV1Enabled = mapped
    }

    /**
     * @param value Whether this site is enabled for Bot Framework V3 protocol.
     */
    @JvmName("kafwuktduxqgckwe")
    public suspend fun isV3Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isV3Enabled = mapped
    }

    /**
     * @param value Whether this site is enabled for Webchat Speech
     */
    @JvmName("prgkhjchtusdyinw")
    public suspend fun isWebChatSpeechEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isWebChatSpeechEnabled = mapped
    }

    /**
     * @param value Whether this site is enabled for preview versions of Webchat
     */
    @JvmName("glammvfunrplhafk")
    public suspend fun isWebchatPreviewEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isWebchatPreviewEnabled = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("fvgpqhlcjhhfpkio")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Tenant Id
     */
    @JvmName("fdsuxudqmjhmdflx")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
     */
    @JvmName("ecunphhvselymoxb")
    public suspend fun trustedOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedOrigins = mapped
    }

    /**
     * @param values List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
     */
    @JvmName("mglbhilwewusexpt")
    public suspend fun trustedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedOrigins = mapped
    }

    internal fun build(): WebChatSiteArgs = WebChatSiteArgs(
        appId = appId,
        eTag = eTag,
        isBlockUserUploadEnabled = isBlockUserUploadEnabled,
        isDetailedLoggingEnabled = isDetailedLoggingEnabled,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        isEndpointParametersEnabled = isEndpointParametersEnabled,
        isNoStorageEnabled = isNoStorageEnabled,
        isSecureSiteEnabled = isSecureSiteEnabled,
        isV1Enabled = isV1Enabled,
        isV3Enabled = isV3Enabled,
        isWebChatSpeechEnabled = isWebChatSpeechEnabled,
        isWebchatPreviewEnabled = isWebchatPreviewEnabled ?: throw
            PulumiNullFieldException("isWebchatPreviewEnabled"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        tenantId = tenantId,
        trustedOrigins = trustedOrigins,
    )
}
