@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters to provide for the Direct Line channel.
 * @property directLineEmbedCode Direct Line embed code of the resource
 * @property extensionKey1 The extensionKey1
 * @property extensionKey2 The extensionKey2
 * @property sites The list of Direct Line sites
 */
public data class DirectLineChannelPropertiesResponse(
    public val directLineEmbedCode: String? = null,
    public val extensionKey1: String? = null,
    public val extensionKey2: String? = null,
    public val sites: List<DirectLineSiteResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.DirectLineChannelPropertiesResponse):
            DirectLineChannelPropertiesResponse = DirectLineChannelPropertiesResponse(
            directLineEmbedCode = javaType.directLineEmbedCode().map({ args0 -> args0 }).orElse(null),
            extensionKey1 = javaType.extensionKey1().map({ args0 -> args0 }).orElse(null),
            extensionKey2 = javaType.extensionKey2().map({ args0 -> args0 }).orElse(null),
            sites = javaType.sites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.DirectLineSiteResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
