@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the DirectLine Speech channel.
 * @property cognitiveServiceRegion The cognitive service region with this channel registration.
 * @property cognitiveServiceResourceId The cognitive service id with this channel registration.
 * @property cognitiveServiceSubscriptionKey The cognitive service subscription key to use with this channel registration.
 * @property customSpeechModelId Custom voice deployment id (optional).
 * @property customVoiceDeploymentId Custom speech model id (optional).
 * @property isDefaultBotForCogSvcAccount Make this a default bot for chosen cognitive service account.
 * @property isEnabled Whether this channel is enabled or not.
 */
public data class DirectLineSpeechChannelPropertiesResponse(
    public val cognitiveServiceRegion: String? = null,
    public val cognitiveServiceResourceId: String? = null,
    public val cognitiveServiceSubscriptionKey: String? = null,
    public val customSpeechModelId: String? = null,
    public val customVoiceDeploymentId: String? = null,
    public val isDefaultBotForCogSvcAccount: Boolean? = null,
    public val isEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.DirectLineSpeechChannelPropertiesResponse):
            DirectLineSpeechChannelPropertiesResponse = DirectLineSpeechChannelPropertiesResponse(
            cognitiveServiceRegion = javaType.cognitiveServiceRegion().map({ args0 -> args0 }).orElse(null),
            cognitiveServiceResourceId = javaType.cognitiveServiceResourceId().map({ args0 ->
                args0
            }).orElse(null),
            cognitiveServiceSubscriptionKey = javaType.cognitiveServiceSubscriptionKey().map({ args0 ->
                args0
            }).orElse(null),
            customSpeechModelId = javaType.customSpeechModelId().map({ args0 -> args0 }).orElse(null),
            customVoiceDeploymentId = javaType.customVoiceDeploymentId().map({ args0 -> args0 }).orElse(null),
            isDefaultBotForCogSvcAccount = javaType.isDefaultBotForCogSvcAccount().map({ args0 ->
                args0
            }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
