@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The ARM channel of list channel with keys operation response.
 * @property changedTime Changed time of the resource
 * @property entityTag Entity tag of the resource
 * @property etag Entity Tag.
 * @property id Specifies the resource ID.
 * @property kind Required. Gets or sets the Kind of the resource.
 * @property location Specifies the location of the resource.
 * @property name Specifies the name of the resource.
 * @property properties The set of properties specific to bot channel resource
 * @property provisioningState Provisioning state of the resource
 * @property resource The set of properties specific to bot channel resource
 * @property setting Channel settings
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type Specifies the type of the resource.
 * @property zones Entity zones
 */
public data class ListChannelWithKeysResult(
    public val changedTime: String? = null,
    public val entityTag: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: Any,
    public val provisioningState: String? = null,
    public val resource: Any? = null,
    public val setting: ChannelSettingsResponse? = null,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ListChannelWithKeysResult):
            ListChannelWithKeysResult = ListChannelWithKeysResult(
            changedTime = javaType.changedTime().map({ args0 -> args0 }).orElse(null),
            entityTag = javaType.entityTag().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
            setting = javaType.setting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.ChannelSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
