@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Microsoft Teams channel.
 * @property callingWebHook Calling web hook for Skype channel
 * @property enableCalling Enable calling for Skype channel
 * @property enableGroups Enable groups for Skype channel
 * @property enableMediaCards Enable media cards for Skype channel
 * @property enableMessaging Enable messaging for Skype channel
 * @property enableScreenSharing Enable screen sharing for Skype channel
 * @property enableVideo Enable video for Skype channel
 * @property groupsMode Group mode for Skype channel
 * @property incomingCallRoute Incoming call route for Skype channel
 * @property isEnabled Whether this channel is enabled for the bot
 */
public data class SkypeChannelPropertiesResponse(
    public val callingWebHook: String? = null,
    public val enableCalling: Boolean? = null,
    public val enableGroups: Boolean? = null,
    public val enableMediaCards: Boolean? = null,
    public val enableMessaging: Boolean? = null,
    public val enableScreenSharing: Boolean? = null,
    public val enableVideo: Boolean? = null,
    public val groupsMode: String? = null,
    public val incomingCallRoute: String? = null,
    public val isEnabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.SkypeChannelPropertiesResponse):
            SkypeChannelPropertiesResponse = SkypeChannelPropertiesResponse(
            callingWebHook = javaType.callingWebHook().map({ args0 -> args0 }).orElse(null),
            enableCalling = javaType.enableCalling().map({ args0 -> args0 }).orElse(null),
            enableGroups = javaType.enableGroups().map({ args0 -> args0 }).orElse(null),
            enableMediaCards = javaType.enableMediaCards().map({ args0 -> args0 }).orElse(null),
            enableMessaging = javaType.enableMessaging().map({ args0 -> args0 }).orElse(null),
            enableScreenSharing = javaType.enableScreenSharing().map({ args0 -> args0 }).orElse(null),
            enableVideo = javaType.enableVideo().map({ args0 -> args0 }).orElse(null),
            groupsMode = javaType.groupsMode().map({ args0 -> args0 }).orElse(null),
            incomingCallRoute = javaType.incomingCallRoute().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
        )
    }
}
